### 概述

SmcTool软件是基于工智机控制器开发的MotionSDK的功能演示和调试软件，通过该软件可以查看和监控控制器状态、配置板卡、测试控制器不同功能模块、调试电机系统等。搭配CODESYS适用于各类工智机，使用户控制工智机像使用板卡一样的用法，是一款易用的上位机软件，目前有Framework、.net6、Avalonia等多个版本，能够运行在多个操作平台。

---

### 软件功能

本软件包含以下主要功能：

- 支持全系工智机产品。
- 支持多轴控制，可以最多支持控制8个轴。
- 提供强大的IO控制功能，支持强制IO功能，通过端口控制，可使您的机器轻松实现自动化控制。
- 支持CNC 多轴插补，可以同时控制或使多个坐标轴相互作用，使工件在三个或更多轴上移动，从而实现更复杂的加工操作。
- 支持多个CNC同时工作，可以最多支持两个CNC同时加工。
- 支持龙门双驱，通过同步轴实现精准的协同运动，提供更高效和精确的龙门机床控制，从而帮助制造商提高生产效率和加工品质。
- 支持多种混合回零方式，可以支持Home、Homing等回零。
- 支持多轴分步回零，如：“0;1,2”先回0轴，再同时回1、2轴。
- 支持GCode导入、编辑、运行、暂停、停止等功能

---

### 安装与配置

#### 安装步骤

找到软件安装包

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71cbbbc74f.png)

双击打开安装程序

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71cc4b1e94.png)

一直点击下一步即可安装

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71cce2bece.png)

软件安装完成，电脑桌面找到双击![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71cd612573.png)便可以进入系统界面。

---

### 功能介绍

#### 轴状态

用户需点击![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71d2b5f799.png)按钮，会弹出轴状态显示窗口。状态显示模块用于查看控制器各控制轴的状态，包括轴当前的运动数据（规划位置、实际位置、规划速度、实际速度、规划加速度）、状态（伺服报警、正负限位、IO急停、运动及运动出错、伺服使能以及运动模式）以及可以进行的一些操作（清除状态、伺服使能、位置清零、停止、仿真）。

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71d334c84b.png)

对话框的“轴号”下拉列表可以选择控制轴号，选择后，对话框的标题将显示对应信息。

左边的框中显示的是当前轴的一些运动参数，从上至下分别为实际位置-规划位置-实际速度-规划速度-加速度；

右边的框中显示当前轴的状态标志及运动模式，状态标志以对应图标的颜色表示不同的状态，灰色代表该标志位没有触发，红色代表该标志位已经触发。

对话框下部的一排按钮可以对轴进行一些操作：

“位置清零”用于将当前轴的规划位置和实际位置清零（如果整个电机系统工作在伺服模式下，按下该按钮还能实现自动的零漂补偿）。

“清除状态”用于清除控制器中存在的不正常状态（关于清除控制器不正常状态，请查看编程手册中的相关说明）。

“伺服使能”用于使能或者关闭对应轴的伺服使能，使能成功，则上面的伺服使能标志图标将变为绿色（通讯正常情况下，控制轴不能上伺服的情况主要有以下几种情况：一、控制器存在伺服报警，此时需要查看控制器与电机系统是否正常连接；二是如果未连接工智机）。

“停止”用于停止对应的运动。

“仿真”用于虚轴演示进行数据模拟使用。

#### 轴基本运动

JOG运动

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71d4df215b.png)

用户需点击![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71d55614fb.png)按钮，启动Jog模块后，选择控制轴号。然后输入运动参数，包括速度、加速度、减速度（各个运动参数详细说明请查看控制器的编程手册）。在“正向”按钮上按下鼠标左键，则对应轴将按照设定的运动参数正向运动，松开鼠标左键则运动停止。在“负向”按钮上按下鼠标左键，则对应轴将按照设定的运动参数负向运动，松开鼠标左键则运动停止。

输入参数的范围为：加速度减速度大于零，速度可正可负。

Move运动

 ![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71d5c191b7.png)

用户需点击![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71d6793e25.png) 按钮，启动点位运动模块后，选择控制轴号。然后输入运动参数，包括速度、步长、加速度、减速度。点击“启动运动”，则对应轴将按照设定的运动参数运动。

输入数据的范围为：速度大于零、步长可正可负（正负决定运动方向）、加速度减速度必须大于零。

#### 回零运动

回零：通常在设备运行前或任务结束后，需要进行回零运动以确保设备回到安全位置或准确位置，为下一次任务的执行做准备。

用户可以通过SmcTool软件进行控制和调整，按住 按钮使设备按照预定的路径和速度返回到指定位置。

通过菜单栏选择工具栏里的控制器配置，可对回零动作进行配置，如下图所示：

 ![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71d796dd13.png)

其中包含了对回零位置、高低速回零时各速度的设置、回零方向的设置以及回零模式。

1.回零方向：

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71d84369bf.png)

（1）shortest:根据最短的距离，选择回零方向

（2）positive:向正方向回零

（3）current：保持当前方向回零

（4）fastest: 自动选择回零方向

（5）negative:向负方向回零

2.回零模式：

 ![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a71d8fc0bb6.png)

（1）FATT\_BSLOW\_S\_STOP:

Move with fast velocity onto the reference switch; invert and move with slow velocity out of the reference switch; execute “set position”; stop

（2）FFAST\_BSLOW\_STOP\_S:

Move with fast velocity onto the reference switch; invert and move with slow velocity out of the reference switch; stop; execute “set position”

（3）FFAST\_BSLOW\_I\_S\_STOP：

Move with fast velocity onto the reference switch; invert and move with slow velocity out of the reference switch; wait for the index pulse; execute “set position”; stop

（4）FAST\_SLOW\_S\_STOP:

Move with fast velocity onto the reference switch; move with slow velocity out of the reference switch; execute “set position”; stop

（5）FAST\_SLOW\_STOP\_S:

Move with fast velocity onto the reference switch; move with slow velocity out of the reference switch; stop; execute “set position”

（6）FAST\_SLOW\_ I\_S\_STOP

Move with fast velocity onto the reference switch; move with slow velocity out of the reference switch; wait for the index pulse; execute “set position”; stop

3.在参数配置的选项中，可以对回零顺序以及回零后到达位置进行设置：

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a72135999f0.png)

#### IO状态

数字量输入输出模块用于查看控制器数字量输入的状态以及输出或强制新的状态。对应的状态列未勾选（或右边灯是灰色）表示没有触发，状态列勾选（右边灯是绿色）代表对应的位有输出。在对应的状态列图标上单击勾选，能改变对应位的状态。

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a7214744520.png)

#### 控制器参数配置

启动SmcTool软件，点击主界面菜单【工具】--&gt;【控制器配置】，将会弹出控制器配置模块对话框。如下图所示：

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a7215b57515.png)

控制器配置模块包含两个菜单，【文件】菜单包括【从文件加载】和【写入到文件】两个菜单项，前者用于将文件中保存的配置信息导入到配置器，后者将设定的配置信息写入到指定的文件。【控制】菜单包括【读取控制器状态】和【写入控制器状态】菜单项，前者可以将当前控制器中的配置信息读取并反应到配置器界面上，而后者用于将修改之后的配置信息写入控制器中。

目前有两种回零方式的配置，不勾选【Using Homing】则为使用Home回零方式，原点开关传感器接在驱动器层，勾选则为使用Homing回零方式，原点开关传感器接在IO模块层。

#### G代码编辑与运行

启动SmcTool软件，点击主界面菜单【GCode】，将会弹出GCode编辑模块对话框。如下图所示：

![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a7216e9abfd.png)

启动运动程序编译器，可以加载本地已写好的G代码，也可以在代码编辑区直接编写。编辑好后可在菜单栏直接点击【下载】，G代码将会下载到工智机内，保存在工智机/opt/SinsegyeRTE/PlcLogic/Channel-0.cnc此目录下。下载Dowload完成后便可点击【运行】，使其运行起来，运行时会有行数返回使其行进行高亮显示，使用户更加清晰的知道运行到哪一行。软件也可支持暂停/继续功能，使其用户体验更佳。

#### 电子齿轮

电子齿轮是一种在运动控制系统（如电机驱动系统）中广泛应用的功能。它是通过软件或电子装置来模拟机械齿轮的传动比功能，主要用于协调电机的旋转速度与负载所需的运动速度之间的关系。

启动SmcTool软件，点击主界面菜单【工具】-【电子齿轮】，将会弹出电子齿轮编辑模块对话框。如下图所示：

 ![](https://resource.helplook.net/docker_production/3648ne/article/PN3NzeGZ/67a72179be6c4.png)

SlotID 被用作当前电子齿轮的标识号，MasterID 用于设定主轴的轴号，SlaveID 则用于设定从轴的轴号。当完成对这些 ID 的编辑并点击 “设置” 后，系统会自动保存相应的 ID 信息。当用户点击 “耦合” 时，主从轴会即刻形成耦合，从轴将按照与主轴相同的速度和距离进行跟随；若点击 “解耦”，从轴将不再与主轴保持跟随关系。